<?php

$this->pageTitle = Yii::app()->name . ' - Nieaktywni uczniowie';

$this->breadcrumbs = array(
	'Nieaktywni uczniowie'
);

Yii::app()->clientScript->registerScript('form', '

	$("#selectDeselectAll").click(function(){
		var schoolId = $(".schoolContainer:visible").attr("schoolId");
		if($(\'.schoolContainer[schoolId="\'+schoolId+\'"] [id^="selected_group_"]:checked\').length == $(\'.schoolContainer[schoolId="\'+schoolId+\'"] [id^="selected_group_"]\').length && (\'.schoolContainer[schoolId="\'+schoolId+\'"] [id^="selected_group_"]:checked\').length>0)
			$(\'.schoolContainer[schoolId="\'+schoolId+\'"] [id^="selected_group_"]\').prop("checked", false);
		else
			$(\'.schoolContainer[schoolId="\'+schoolId+\'"] [id^="selected_group_"]\').prop("checked", true);
		return false;
	});

	$("#activateMany").click(function(){
		$("#userActivationForm").attr("action", "'.$this->createAbsoluteUrl('/administration/main/activateGroups').'");
		$("#userActivationForm").submit();
	});

	$(".activateSingle").click(function(){
		$(\'[id^="selected_group_"]\').prop("checked",false);
		$(\'[id="selected_group_\'+$(this).attr("companyId")+\'"]\').prop("checked",true);
		$("#userActivationForm").attr("action", "'.$this->createAbsoluteUrl('/administration/main/activateGroups').'");
		$("#userActivationForm").submit();
	});

	$("#rejectMany").click(function(){
		var selectedGroups = new Array();
		$(\'[id^="selected_group_"]:checked\').each(function(){
			selectedGroups.push($(this).attr("companyId"));
		});
		window.location = "'.$this->createAbsoluteUrl('/administration/main/rejectGroups', array('companyIds'=>'company_ids_template')).'".replace("company_ids_template",selectedGroups.join());
	});

	$(".rejectSingle").click(function(){
		window.location = "'.$this->createAbsoluteUrl('/administration/main/rejectGroups', array('companyIds'=>'company_ids_template')).'".replace("company_ids_template",$(this).attr("companyId"));
	});

	function schoolSelect(select)
	{
		$(".schoolContainer").hide();
		var schoolSelected = select.val();
		$(\'.schoolContainer[schoolId="\'+schoolSelected+\'"]\').show();
		$(\'[id^="selected_group_"]\').prop("checked", false);
	}
	
	$("#schoolSelect").change(function(){
		schoolSelect($(this));
	});
	
	schoolSelect($("#schoolSelect"));
', CClientScript::POS_READY);

?>
<h1>Nieaktywni użytkownicy</h1>

<?php if(Yii::app()->user->hasFlash('groupActivated')): ?>
	<div class="flash-success">
		<?php echo Yii::app()->user->getFlash('groupActivated'); ?>
	</div>
<?php endif; ?>

<b>Szkoła:</b><br />
<?php if(Yii::app()->user->role == 'admin'): ?>
<select id="schoolSelect">
	<option value="-1">
		Wybierz szkołę
	</option>
	<?php foreach($schools as $school): ?>
		<option value="<?php echo $school->id ?>">
			<?php echo $school->nazwa ?>
		</option>
	<?php endforeach; ?>
</select>
<?php elseif(Yii::app()->user->role == 'schoolAdmin' && Yii::app()->user->getState('schoolId') !== null): ?>
	<?php echo CHtml::dropDownList('schoolSelect', Yii::app()->user->getState('schoolId'), CHtml::listData($schools, 'id', 'nazwa'), array('disabled'=>'disabled', 'id'=>'schoolSelect')); ?>
<?php endif; ?>
<br /><br />

<a href="#" class="buttonS bGreen" id="activateMany">Aktywuj wybranych</a> |
<a href="#" class="buttonS bRed" id="rejectMany">Usuń wybranych</a>
<br /><br />

<form id="userActivationForm" method="POST">
	<?php foreach($schools as $school): ?>
		<div class="schoolContainer" schoolId="<?php echo $school->id ?>" style="display: none;">
			<?php foreach($school->klasy as $class): ?>
				<?php
				echo '<h3>Klasa '.$class->nazwa.'</h3>'; ?>
				<?php $groupNr = 1;
					foreach($class->nieaktywneFirmy as $group):
						$lastGroup = end($group); ?>
					<div style="width:100%; border: 1px solid #E5F1F4; margin: 5px; padding: 5px; float: left;">
						<h4 style="margin-bottom: 0.50em;">Grupa nr <?php echo $groupNr++; ?></h4>
						<input name="Group[<?php echo $group->id ?>][selected]" id="selected_group_<?php echo $group->id ?>" companyId="<?php echo $group->id ?>" type="checkbox">
						<label for="selected_group_<?php echo $group->id ?>"><b>Zaznacz tę grupę</b></label> |
						<a href="#" class="buttonS bGreen activateSingle" companyId="<?php echo $group->id ?>">Aktywuj tę grupę</a> |
						<a href="#" class="buttonS bRed rejectSingle" companyId="<?php echo $group->id ?>">Odrzuć tę grupę</a> |
						Przypisz grupę do <input type="radio" name="Group[<?php echo $group->id ?>][assign]" value="newCompany" checked="checked" id="assignToNewCompany_<?php echo $group->id ?>" />
									<label for="assignToNewCompany_<?php echo $group->id ?>"><b>Nowej firmy</b></label>
									<input type="radio" name="Group[<?php echo $group->id ?>][assign]" value="existingCompany" id="assignToExistingCompany_<?php echo $group->id ?>" />
									<label for="assignToExistingCompany_<?php echo $group->id ?>"><b>Istniejącej firmy</b></label>
									<select name="Group[<?php echo $group->id ?>][existingCompany]">
										<?php foreach($class->aktywneFirmy as $company): ?>
												<option value="<?php echo $company->id ?>">
													<?php echo $company->nazwa; ?>
												</option>
										<?php endforeach; ?>
									</select>
						<?php
							$this->widget('zii.widgets.grid.CGridView', array(
								'id'=>'parametry-gry-grid',
								'dataProvider'=> new CArrayDataProvider($group->uzytkownicy(array('condition'=>'"status" not in (2,3)'))),
								'htmlOptions'=>array('class'=>'tDefault', 'style'=>'margin-top:15px'),
								'summaryText'=>'',
								'columns'=>array(
									array(
										'name'=>'imie',
										'header'=>'Imię'
									),
									array(
										'name'=>'nazwisko',
										'header'=>'Nazwisko'
									),
									array(
										'name'=>'email',
										'header'=>'E-mail'
									),
									array(
										'name'=>'pesel',
										'header'=>'PESEL'
									),
								),
							));
						?>
					</div>
				<?php endforeach; ?>
			<?php endforeach; ?>
		</div>
	<?php endforeach; ?>
</form>

<a id="selectDeselectAll" href="#">zaznacz/odznacz wszystkie grupy</a>


